<?xml version="1.0"?>
<!-- Stylesheet converting gxl to xmi -->
<!-- $Id: gxl2xmi.xsl,v 1.6 2004/10/20 17:50:38 schneider Exp $ -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
				xmlns:UML="http://www.omg.org/uml/1.3"
				xmlns:xlink="http://www.w3.org/1999/xlink">
				
				
	<xsl:output method="xml" 
				omit-xml-declaration="no" 
				standalone="no" 
				indent="yes"/>
	<!-- doctype-system="//org.omg/UML/1.3"/> -->
	
	<xsl:variable name="VISIBILITY_PRIVATE">0</xsl:variable>
	<xsl:variable name="VISIBILITY_PUBLIC">1</xsl:variable>
	<xsl:variable name="VISIBILITY_PROTECTED">2</xsl:variable>
	<xsl:variable name="VISIBILITY_PACKAGE">3</xsl:variable>
	<xsl:variable name="VISIBILITY_USERDEF">4</xsl:variable>
	<xsl:variable name="ROLE_AGGREGATION">1</xsl:variable>
	<xsl:variable name="ROLE_COMPOSITION">2</xsl:variable>
	<xsl:variable name="DATATYPE_PREFIX">datatype.</xsl:variable>
	
	<xsl:key name="node.id" match="node" use="@id"/>
	<xsl:key name="node.type" match="node" use="child::type/@xlink:href"/>
	
	<xsl:key name="edge.from" match="edge" use="@from"/>
	<xsl:key name="edge.to" match="edge" use="@to"/>
	<xsl:key name="edge.type" match="edge" use="child::type/@xlink:href"/>
	
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="gxl">
		<XMI>
			<XMI.header>
				<XMI.documentation>
					<XMI.exporter>Fujaba</XMI.exporter>
					<XMI.exporterVersion>3.0</XMI.exporterVersion>
				</XMI.documentation>
				<XMI.metamodel xmi.name="UML" xmi.version="1.3"/>
			</XMI.header>
			<XMI.content>
				<xsl:apply-templates/>
			</XMI.content>
		</XMI>
	</xsl:template>
	<xsl:template match="graph">
		<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLProject')">
			<xsl:element name="UML:Model">
				<xsl:attribute name="xmi.id">
					<xsl:value-of select="@id"/>
				</xsl:attribute>
				<xsl:attribute name="name">
					<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLProject::name']/string"/>
				</xsl:attribute>
				<xsl:variable name="projectNamespace">
					<xsl:value-of select="@id"/>
				</xsl:variable>
				<xsl:element name="UML:Namespace.ownedElement">
					<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLPackage')">
						<xsl:if test="attr[@name='de.uni_paderborn.fujaba.uml.UMLPackage::name']/string='RootPackage'">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLPackage">
								<xsl:with-param name="namespace">
									<xsl:value-of select="$projectNamespace"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:element>
				<!-- ok -->
				<!-- can't use typelist here -->
				
				<xsl:element name="UML:Namespace.ownedElement">
					<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLTypeList')">
						<xsl:for-each select="key('edge.from',@id)">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLTypeList"/>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
		
		<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLClassDiagram')">
			<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLClassDiagram"/>
		</xsl:for-each>
		<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLActivityDiagram')">
			<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLActivityDiagram"/>
		</xsl:for-each>
		
		<!-- attr <-> assoc -->
		<xsl:for-each select="key('edge.type','de.uni_paderborn.fujaba.uml.UMLRole::associatedAttribute')">

	<xsl:element name="UML:TaggedValue">
	<xsl:attribute name="xmi.id">
	<xsl:value-of select="generate-id()"/>
	</xsl:attribute>
	<xsl:attribute name="tag">
	<xsl:text>clientRole</xsl:text>
	</xsl:attribute>
	
	<xsl:for-each select="key('node.id',@from)">
	<xsl:attribute name="value">
		<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLRole::name']/string"/>
	</xsl:attribute>
	</xsl:for-each>
	
	<xsl:element name="UML:TaggedValue.modelElement">
	<xsl:element name="Foundation.Core.ModelElement">
	<xsl:attribute name="xmi.idref">
	<xsl:value-of select="@to"/>
	</xsl:attribute>
	</xsl:element>
	</xsl:element>
	</xsl:element>


	<xsl:element name="UML:TaggedValue">
	<xsl:attribute name="xmi.id">
	<xsl:value-of select="generate-id()"/>
	</xsl:attribute>
	<xsl:attribute name="tag">
	<xsl:text>clientCardinality</xsl:text>
	</xsl:attribute>
	
	<xsl:attribute name="value">
	<xsl:text>0..1</xsl:text>
	</xsl:attribute>
	
	<xsl:element name="UML:TaggedValue.modelElement">
	<xsl:element name="Foundation.Core.ModelElement">
	<xsl:attribute name="xmi.idref">
	<xsl:value-of select="@to"/>
	</xsl:attribute>
	</xsl:element>
	</xsl:element>
	</xsl:element>

			
			
		</xsl:for-each>	
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLPackage">
		<xsl:param name="namespace"/>
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Package">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$selfNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="child::attr[@name='de.uni_paderborn.fujaba.uml.UMLPackage::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="namespace">
				<xsl:value-of select="$namespace"/>
			</xsl:attribute>
			<!-- klassen im akt. package -->
			<xsl:for-each select="key('edge.to',$selfNamespace)">
				<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLClass::declaredInPackage'">
					<xsl:for-each select="key('node.id',@from)">
						<xsl:element name="UML:Namespace.ownedElement">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLClass">
								<xsl:with-param name="namespace">
									<xsl:value-of select="$selfNamespace"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:element>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
			<!--  ?? 	subpackages
				<UML:Namespace.ownedElement>
					<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLPackage::packages']">
						<xsl:for-each select="seq/string">
							<xsl:if test="last()=position()">
								<xsl:for-each select="id(text())">
									<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLPackage">
										<xsl:with-param name="namespace">
											<xsl:value-of select="$selfNamespace"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:if>
						</xsl:for-each>
					</xsl:for-each>
				</UML:Namespace.ownedElement>
	-->
			<!-- UML:ActivityGraph -->
			<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLActivityDiagram')">
				<xsl:variable name="activityNamespace">
					<xsl:value-of select="@id"/>
				</xsl:variable>
				<xsl:element name="UML:Namespace.ownedElement">
					<xsl:element name="UML:ActivityGraph">
						<xsl:attribute name="xmi.id">
							<xsl:text>ActivityGraph_</xsl:text>
							<xsl:value-of select="@id"/>
						</xsl:attribute>
						<xsl:attribute name="name">
							<xsl:text>State/Activity Model</xsl:text>
						</xsl:attribute>
						<xsl:element name="UML:StateMachine.context">
							<xsl:element name="Foundation.Core.ModelElement">
								<xsl:attribute name="xmi.idref">
									<xsl:value-of select="$selfNamespace"/>
								</xsl:attribute>
							</xsl:element>
						</xsl:element>
						<xsl:element name="UML:StateMachine.top">
							<xsl:element name="UML:CompositeState">
								<xsl:element name="UML:CompositeState.subvertex">
									<xsl:for-each select="key('edge.from',$activityNamespace)">
										<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.asg.ASGDiagram::elements'">
											<xsl:for-each select="key('node.id',@to)">
												<xsl:if test="not(child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLTransition')">
													<xsl:choose>
														<xsl:when test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLStartActivity'">
															<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLStartActivity"/>
														</xsl:when>
														<xsl:when test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLStoryActivity'">
															<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLStoryActivity"/>
														</xsl:when>
														<xsl:when test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLNopActivity'">
															<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLNopActivity"/>
														</xsl:when>
														<xsl:when test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLStatementActivity'">
															<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLStatementActivity"/>
														</xsl:when>
														<xsl:when test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLStopActivity'">
															<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLStopActivity"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:comment>
																<xsl:text>unsupported part of activity graph: </xsl:text>
																<xsl:value-of select="child::type/@xlink:href"/>
															</xsl:comment>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
											</xsl:for-each>
										</xsl:if>
									</xsl:for-each>
								</xsl:element>
							</xsl:element>
						</xsl:element> <!-- UML:StateMachine.top -->
						
						<xsl:element name="UML:StateMachine.transitions">
							<xsl:for-each select="key('edge.from',$activityNamespace)">
								<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.asg.ASGDiagram::elements'">
									<xsl:for-each select="key('node.id',@to)">
										<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLTransition'">
											<xsl:variable name="transitionNamespace">
												<xsl:value-of select="@id"/>
											</xsl:variable>
											<xsl:element name="UML:Transition">
												<xsl:attribute name="xmi.id">
													<xsl:value-of select="@id"/>
												</xsl:attribute>
												<xsl:attribute name="name">
													<xsl:text>link</xsl:text>
												</xsl:attribute>
												<xsl:element name="UML:Transition.source">
													<xsl:element name="Behavioral_Elements.State_Machines.StateVertex">
														<xsl:for-each select="key('edge.from',$transitionNamespace)">
															<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLTransition::revExit'">
																<xsl:attribute name="xmi.idref">
																	<xsl:value-of select="@to"/>
																</xsl:attribute>
															</xsl:if>
														</xsl:for-each>
													</xsl:element>
												</xsl:element>
												<xsl:element name="UML:Transition.target">
													<xsl:element name="Behavioral_Elements.State_Machines.StateVertex">
														<xsl:for-each select="key('edge.from',$transitionNamespace)">
															<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLTransition::revEntry'">
																<xsl:attribute name="xmi.idref">
																	<xsl:value-of select="@to"/>
																</xsl:attribute>
															</xsl:if>
														</xsl:for-each>
												</xsl:element>
												</xsl:element>
											</xsl:element>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>	<!-- UML:ActivityGraph -->
				</xsl:element>
			</xsl:for-each>

			<!-- assoc -->
			<xsl:element name="UML:Namespace.ownedElement">
				<xsl:for-each select="key('node.type','de.uni_paderborn.fujaba.uml.UMLAssoc')">
					<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLAssoc">
						<xsl:with-param name="namespace">
							<xsl:value-of select="$selfNamespace"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLStartActivity">
		<xsl:variable name="stateNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Pseudostate">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$stateNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="child::attr[@name='de.uni_paderborn.fujaba.uml.UMLStartActivity::storyName']/string"/>
			</xsl:attribute>
			<xsl:attribute name="kind">
				<xsl:text>initial</xsl:text>
			</xsl:attribute>
			<xsl:element name="UML:StateVertex.outgoing">
				<xsl:for-each select="key('edge.from',$stateNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLActivity::exit'">
						<xsl:element name="Behavioral_Elements.State_Machines.Transition">		
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:element>			
					</xsl:if>
				</xsl:for-each>
			</xsl:element>	
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLStoryActivity">
		<xsl:variable name="stateNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:CompositeState">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$stateNamespace"/>
			</xsl:attribute>
			<!--
			<xsl:attribute name="name">
				<xsl:value-of select="child::attr[@name='de.uni_paderborn.fujaba.uml.UMLStoryActivity::storyName']/string"/>
			</xsl:attribute>
			-->
			<xsl:attribute name="kind">
				<xsl:text>initial</xsl:text>
			</xsl:attribute>
			<!-- <UML:CompositeState.subvertex/> -->
			<xsl:element name="UML:StateVertex.outgoing">
				<xsl:for-each select="key('edge.from',$stateNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLActivity::exit'">
						<xsl:element name="Behavioral_Elements.State_Machines.Transition">		
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:element>			
					</xsl:if>
				</xsl:for-each>
			</xsl:element>	
		</xsl:element>
	
		<xsl:element name="UML:ModelElement.namespace">
			<xsl:element name="UML:Namespace">
				<xsl:attribute name="xmi.id">
					<xsl:value-of select="generate-id()"/>
				</xsl:attribute>
				<xsl:element name="UML:Namespace.ownedElement">
				
				
				
				</xsl:element>
			</xsl:element>
		</xsl:element>
	     <!--
        
         <UML:ModelElement.namespace>
          <UML:Namespace xmi.id = 'XX.18' name = ''>
           <UML:Namespace.ownedElement>
           
            <UML:ClassifierRole xmi.id = 'G.4' name = 'Object2' visibility = 'package'>
            
             <UML:ClassifierRole.multiplicity>
              <UML:Multiplicity>
               <UML:Multiplicity.range>
                <UML:MultiplicityRange lower = '1' upper = '1'/>
               </UML:Multiplicity.range>
              </UML:Multiplicity>
             </UML:ClassifierRole.multiplicity>
             
             <UML:ClassifierRole.base>
              <Foundation.Core.Classifier/>
             </UML:ClassifierRole.base>
             
            </UML:ClassifierRole>
            
            
            
           </UML:Namespace.ownedElement>
          </UML:Namespace>
         </UML:ModelElement.namespace>
         
         
        
        
        
        
        	<node id="id1952">
			<type xlink:href="de.uni_paderborn.fujaba.uml.UMLStoryActivity" xlink:type="simple"/>
			<attr name="de.uni_paderborn.fujaba.uml.UMLStoryActivity::forEach">
				<string>false</string>
			</attr>
			<attr name="de.uni_paderborn.fujaba.asg.ASGElement::toBeMapped">
				<string>false</string>
			</attr>
			<attr name="de.uni_paderborn.fujaba.uml.UMLIncrement::readOnly">
				<string>false</string>
			</attr>
			<attr name="de.uni_paderborn.fujaba.basic.BasicIncrement::generated">
				<string>false</string>
			</attr>
		</node>
		
		
		<edge from="id1952" to="id1950">
			<type xlink:href="de.uni_paderborn.fujaba.uml.UMLStoryActivity::storyPattern"/>
		</edge>
		
		
		<edge from="id1952" to="id1954">
			<type xlink:href="de.uni_paderborn.fujaba.uml.UMLActivity::entry"/>
		</edge>
		<edge from="id1952" to="id1984">
			<type xlink:href="de.uni_paderborn.fujaba.uml.UMLActivity::exit"/>
		</edge>
		<edge from="id1952" to="id2019">
			<type xlink:href="de.uni_paderborn.fujaba.uml.UMLActivity::exit"/>
		</edge>
		<edge from="id1952" to="id1945">
			<type xlink:href="de.uni_paderborn.fujaba.asg.ASGElement::diagrams"/>
		</edge>
        
        -->
		<xsl:comment>
			<xsl:value-of select="child::type/@xlink:href"/>
		</xsl:comment>
	</xsl:template>


	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLNopActivity">
		<xsl:variable name="stateNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Pseudostate">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$stateNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="kind">
				<xsl:text>branch</xsl:text>
			</xsl:attribute>
			<xsl:element name="UML:StateVertex.outgoing">
				<xsl:for-each select="key('edge.from',$stateNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLActivity::exit'">
						<xsl:element name="Behavioral_Elements.State_Machines.Transition">		
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:element>			
					</xsl:if>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>


	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLStatementActivity">
		<xsl:variable name="stateNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:variable name="statement">
			<xsl:value-of select="../edge[@from=$stateNamespace and child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLStatementActivity::state']/@to"/>
		</xsl:variable>
		<xsl:element name="UML:ActionState">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$stateNamespace"/>
			</xsl:attribute>
			
			<xsl:for-each select="key('node.id',$statement)">
				<xsl:attribute name="name">
					<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLStatement::statement']/string"/>
				</xsl:attribute>		
			</xsl:for-each>
			
			<!--
			<xsl:attribute name="name">
				<xsl:value-of select="../node[@id=$statement]/attr[@name='de.uni_paderborn.fujaba.uml.UMLStatement::statement']/string"/>
			</xsl:attribute> 
			-->
			<xsl:element name="UML:StateVertex.outgoing">
				<xsl:for-each select="key('edge.from',$stateNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLActivity::exit'">
						<xsl:element name="Behavioral_Elements.State_Machines.Transition">		
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:element>			
					</xsl:if>
				</xsl:for-each>
			</xsl:element>															
		</xsl:element>
	</xsl:template>


	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLStopActivity">
		<xsl:element name="UML:FinalState">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:text>EndState.</xsl:text>
				<xsl:value-of select="position()"/>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>


	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLTypeList">
		<xsl:if test="type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLTypeList::types'">
			<xsl:element name="UML:DataType">
				<xsl:attribute name="xmi.id">
					<xsl:value-of select="$DATATYPE_PREFIX"/>
					<xsl:value-of select="@to"/>
				</xsl:attribute>
				<xsl:attribute name="name">
					<xsl:value-of select="attr[@name='key']/string"/>
				</xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLClass">
		<xsl:param name="namespace"/>
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Class">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$selfNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLClass::name']/string"/>
			</xsl:attribute>
			<!-- static modifier support missing HERE -->
			<xsl:attribute name="isAbstract">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLClass::umlAbstract']/string"/>
			</xsl:attribute>
			<xsl:attribute name="visibility">
				<xsl:variable name="vis">
					<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLDeclaration::visibility']/string"/>
				</xsl:variable>
				<xsl:call-template name="UMLVisibility">
					<xsl:with-param name="vis">
						<xsl:value-of select="$vis"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="namespace">
				<xsl:value-of select="$namespace"/>
			</xsl:attribute>
			<UML:ModelElement.stereotype>
				<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLClass::stereotypes']/string">
					<xsl:for-each select="id(text())">
						<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLStereotype">
							<xsl:with-param name="namespace">
								<xsl:value-of select="$selfNamespace"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:for-each>
			</UML:ModelElement.stereotype>
			<UML:Classifier.feature>
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLClass::attrs'">
						<xsl:for-each select="key('node.id',@to)">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLAttr">
								<xsl:with-param name="owner">
									<xsl:value-of select="$selfNamespace"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</UML:Classifier.feature>
			<UML:Classifier.feature>
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLClass::methods'">
						<xsl:for-each select="key('node.id',@to)">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLMethod">
								<xsl:with-param name="owner">
									<xsl:value-of select="$selfNamespace"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</UML:Classifier.feature>
			<xsl:for-each select="key('edge.from',$selfNamespace)">
				<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLClass::revSubclass'">
					<xsl:variable name="generalization">
						<xsl:value-of select="@to"/>
					</xsl:variable>
					<xsl:element name="UML:Namespace.ownedElement">
						<xsl:for-each select="key('node.id',$generalization)">
							<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLGeneralization'">
								<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLGeneralization">
									<xsl:with-param name="namespace">
										<xsl:value-of select="$namespace"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</xsl:for-each>
					</xsl:element>			
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLStereotype">
		<UML:Stereotype>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLStereotype::text']/string"/>
			</xsl:attribute>
		</UML:Stereotype>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLAttr">
		<xsl:param name="owner"/>
		<xsl:element name="UML:Attribute">
			<xsl:variable name="self">
				<xsl:value-of select="@id"/>
			</xsl:variable>
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="visibility">
				<xsl:variable name="vis">
					<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::umlVisibility']/string"/>
				</xsl:variable>
				<xsl:call-template name="UMLVisibility">
					<xsl:with-param name="vis">
						<xsl:value-of select="$vis"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="changeable">
				<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::javaFinal']">
					<xsl:choose>
						<xsl:when test="child::string='false'">
							<xsl:text>none</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>frozen</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:attribute>
			<xsl:attribute name="ownerScope">
				<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::umlStatic']">
					<xsl:choose>
						<xsl:when test="child::string='false'">
							<xsl:text>instance</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>classifier</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:attribute>
			<xsl:attribute name="owner">
				<xsl:value-of select="$owner"/>
			</xsl:attribute>
			
			
			<xsl:for-each select="key('edge.from',$self)">
				<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLAttr::attrType'">
					<xsl:element name="UML:StructuralFeature.type">
						<xsl:element name="Foundation.Core.Classifier">
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="$DATATYPE_PREFIX"/>
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			
			<xsl:if test="string-length(attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::initialValue']/string)&gt;0">
				<xsl:element name="UML:Attribute.initialValue">
					<xsl:element name="UML:Expression">
						<xsl:attribute name="language">
							<xsl:text>java</xsl:text>
						</xsl:attribute>
						<xsl:attribute name="body">
							<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAttr::initialValue']/string"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:element>
			</xsl:if>
			<!-- fix me: constraints here -->
		</xsl:element>
		
		
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLMethod">
		<xsl:param name="owner"/>
		<xsl:param name="ownid">
			<xsl:value-of select="@id"/>
		</xsl:param>
		<xsl:element name="UML:Operation">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$ownid"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLMethod::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="visibility">
				<xsl:variable name="vis">
					<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLDeclaration::visibility']/string"/>
				</xsl:variable>
				<xsl:call-template name="UMLVisibility">
					<xsl:with-param name="vis">
						<xsl:value-of select="$vis"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="ownerScope">
				<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLMethod::umlStatic']">
					<xsl:choose>
						<xsl:when test="child::string='false'">
							<xsl:text>instance</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>classifier</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:attribute>
			<xsl:attribute name="owner">
				<xsl:value-of select="$owner"/>
			</xsl:attribute>
			<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLMethod::umlSynchronized']/string">
				<xsl:if test="text()='true'">
					<xsl:attribute name="concurrency">
						<xsl:text>sequencial</xsl:text>
					</xsl:attribute>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLMethod::umlAbstract']/string">
				<xsl:if test="text()='false'">
					<xsl:element name="UML:Operation.method">
						<xsl:element name="UML:Method">
							<xsl:attribute name="owner">
								<xsl:value-of select="$owner"/>
							</xsl:attribute>
							<xsl:attribute name="specification">
								<xsl:value-of select="$ownid"/>
							</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="key('edge.from',$ownid)">
				<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLMethod::param'">
					<xsl:for-each select="key('node.id',@to)">
						<xsl:element name="UML:BehavioralFeature.parameter">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLParam">
								<xsl:with-param name="owner">
									<xsl:value-of select="$owner"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:element>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
			<!--
					fix me: no idea how to do this (it should point to an UML:Exception but
					in our meta-model it is simply a UMLType
		         	<UML:BehavioralFeature.raisedException></UML:BehavioralFeature.raisedException>
     		-->
			<xsl:for-each select="key('edge.from',$ownid)">
				<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLMethod::resultType'">
					<xsl:element name="UML:BehavioralFeature.parameter">
						<xsl:element name="UML:Parameter">
							<xsl:attribute name="kind">return</xsl:attribute>
							<xsl:element name="UML:Parameter.type">
								<xsl:element name="Foundation.Core.Classifier">
									<xsl:attribute name="xmi.idref">
										<xsl:value-of select="$DATATYPE_PREFIX"/>
										<xsl:value-of select="@to"/>
									</xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLParam">
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Parameter">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLParam::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="kind">inout</xsl:attribute>
			<xsl:element name="UML:Parameter.type">
				<xsl:element name="Foundation.Core.Classifier">
					<xsl:for-each select="key('edge.from',$selfNamespace)">
						<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLParam::paramType'">
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="$DATATYPE_PREFIX"/>
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:if>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLRole">
		<xsl:variable name="aggr">
			<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLRole::adornment']/string"/>
		</xsl:variable>
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:AssociationEnd">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLRole::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="isNavigable">
				<xsl:value-of select="boolean($aggr!=3)"/>
				<!-- 3 = REFERENCE -->
			</xsl:attribute>
			<!-- fix me: ordered attribute here -->
			<xsl:attribute name="aggregation">
				<xsl:choose>
					<xsl:when test="$aggr=$ROLE_AGGREGATION">
						<xsl:text>aggregate</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$aggr=$ROLE_COMPOSITION">
								<xsl:text>composite</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<!--
			<xsl:for-each select="attr[@name='de.uni_paderborn.fujaba.uml.UMLRole::qualifier']">
				<UML:AssociationEnd.qualifier>
					<!- - fix me: UML permits only Attributes as Qualifiers, we allow any names - ->
					<UML:Attribute>
						<xsl:attribute name="xmi.idref">
							<xsl:value-of select="string"/>
						</xsl:attribute>
					</UML:Attribute>
				</UML:AssociationEnd.qualifier>
			</xsl:for-each>
			-->
			<!--  
			1
			0..1
			1..*(-1)
			0..*(-1)

			<xsl:variable name="card">
				<xsl:value-of select="../node[@id=../edge[@from=$selfNamespace and child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLRole::card']/@to]/attr[@name='de.uni_paderborn.fujaba.uml.UMLCardinality::cardString']/string"/>
			</xsl:variable>
			-->			
			<xsl:variable name="card">		
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLRole::card'">
						<xsl:for-each select="key('node.id',@to)">
							<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLCardinality::cardString']/string"/>
						</xsl:for-each>	
					</xsl:if>
				</xsl:for-each>		
			</xsl:variable>					

			<xsl:element name="UML:AssociationEnd.multiplicity">
				<xsl:element name="UML:Multiplicity">
					<xsl:element name="UML:Multiplicity.range">
						<xsl:element name="UML:MultiplicityRange">
						
							<xsl:attribute name="lower">
								<xsl:choose>
									<xsl:when test="not(contains($card,'..'))">
										<xsl:text>0</xsl:text>	
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="substring-before($card,'..')"/>	
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							
							<xsl:attribute name="upper">		
								<xsl:choose>
									<xsl:when test="not(contains($card,'..'))">
										<xsl:value-of select="translate($card,'n','*')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="substring-after($card,'..')"/>	
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:element name="UML:AssociationEnd.type">
				<xsl:element name="Foundation.Core.Classifier">
					<xsl:for-each select="key('edge.to',$selfNamespace)">
						<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLClass::roles'">
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@from"/>
							</xsl:attribute>
						</xsl:if>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLAssoc">
		<xsl:param name="namespace"/>
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Association">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$selfNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLAssoc::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="namespace">
				<xsl:value-of select="$namespace"/>
			</xsl:attribute>
			<xsl:element name="UML:Association.connection">
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLAssoc::rightRole' or child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLAssoc::leftRole'">
						<xsl:for-each select="key('node.id',@to)">
							<xsl:call-template name="de.uni_paderborn.fujaba.uml.UMLRole"/>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLGeneralization">
		<xsl:param name="namespace"/>
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:variable name="sub">
			<xsl:value-of select="../edge[@from=$selfNamespace and child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLGeneralization::subclass']/@to"/>
		</xsl:variable>
		<xsl:variable name="super">
			<xsl:value-of select="../edge[@from=$selfNamespace and child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLGeneralization::superclass']/@to"/>
		</xsl:variable>
		<UML:Generalization>
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="$selfNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="namespace">
				<xsl:value-of select="$namespace"/>
			</xsl:attribute>
			<xsl:attribute name="subtype">
				<xsl:value-of select="$sub"/>
			</xsl:attribute>
			<xsl:attribute name="supertype">
				<xsl:value-of select="$super"/>
			</xsl:attribute>
			<UML:Generalization.child>
				<Foundation.Core.GeneralizableElement>
					<xsl:attribute name="xmi.idref">
						<xsl:value-of select="$sub"/>
					</xsl:attribute>
				</Foundation.Core.GeneralizableElement>
			</UML:Generalization.child>
			<UML:Generalization.parent>
				<Foundation.Core.GeneralizableElement>
					<xsl:attribute name="xmi.idref">
						<xsl:value-of select="$super"/>
					</xsl:attribute>
				</Foundation.Core.GeneralizableElement>
			</UML:Generalization.parent>
		</UML:Generalization>
	</xsl:template>
	<xsl:template name="UMLVisibility">
		<xsl:param name="vis"/>
		<xsl:choose>
			<xsl:when test="$vis=$VISIBILITY_PRIVATE">
				<xsl:text>private</xsl:text>
			</xsl:when>
			<xsl:when test="$vis=$VISIBILITY_PUBLIC">
				<xsl:text>public</xsl:text>
			</xsl:when>
			<xsl:when test="$vis=$VISIBILITY_PROTECTED">
				<xsl:text>protected</xsl:text>
			</xsl:when>
			<xsl:when test="$vis=$VISIBILITY_PACKAGE">
				<!-- package -->
				<xsl:text>private</xsl:text>
			</xsl:when>
			<xsl:when test="$vis=$VISIBILITY_USERDEF">
				<!-- user-defined -->
				<xsl:text>public</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLClassDiagram">
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:element name="UML:Diagram">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="attr[@name='de.uni_paderborn.fujaba.uml.UMLDiagram::name']/string"/>
			</xsl:attribute>
			<xsl:attribute name="toolName">
				<xsl:text>Fujaba</xsl:text>
			</xsl:attribute>
			<xsl:attribute name="diagramType">
				<xsl:text>ClassDiagram</xsl:text>
			</xsl:attribute>
			<xsl:element name="UML:Diagram.owner">
				<xsl:element name="Foundation.Core.ModelElement">
					<xsl:attribute name="xmi.idref">
						<!-- fix me -->
						<xsl:text>RootPackage</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:element name="UML:Diagram.element">
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.asg.ASGDiagram::elements'">
						<xsl:element name="UML:DiagramElement">
							<xsl:attribute name="xmi.id">
								<xsl:value-of select="$selfNamespace"/>
								<xsl:text>.</xsl:text>
								<xsl:value-of select="position()"/>
							</xsl:attribute>
							<xsl:element name="UML:PresentationElement.subject">
								<xsl:element name="Foundation.Core.ModelElement">
									<xsl:attribute name="xmi.idref">
										<xsl:value-of select="@to"/>
									</xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template name="de.uni_paderborn.fujaba.uml.UMLActivityDiagram">
		<xsl:variable name="selfNamespace">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<!-- assoc method <-> activityDiag -->
		<xsl:element name="UML:TaggedValue">
			<xsl:attribute name="xmi.id">
				<xsl:text>TaggedValue.</xsl:text>
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="tag">
				<xsl:text>associates</xsl:text>
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:text>&lt;{</xsl:text>
				<xsl:value-of select="translate(child::attr[@name='de.uni_paderborn.fujaba.uml.UMLDiagram::name']/string,'::','_')"/>
				<xsl:text>}&gt;</xsl:text>
			</xsl:attribute>
			<xsl:element name="UML:TaggedValue.modelElement">
				<xsl:element name="Foundation.Core.ModelElement">
					<xsl:for-each select="key('edge.from',$selfNamespace)">
						<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.uml.UMLActivityDiagram::storyMethod'">
							<xsl:attribute name="xmi.idref">
								<xsl:value-of select="@to"/>
							</xsl:attribute>
						</xsl:if>					
					</xsl:for-each>			
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="UML:Diagram">
			<xsl:attribute name="xmi.id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="translate(child::attr[@name='de.uni_paderborn.fujaba.uml.UMLDiagram::name']/string,'::','_')"/>
			</xsl:attribute>
			<xsl:attribute name="toolName">
				<xsl:text>Fujaba</xsl:text>
			</xsl:attribute>
			<xsl:attribute name="diagramType">
				<xsl:text>ActivityDiagram</xsl:text>
			</xsl:attribute>
			<xsl:element name="UML:Diagram.owner">
				<xsl:element name="Foundation.Core.ModelElement">
					<xsl:attribute name="xmi.idref">
						<xsl:text>ActivityGraph_</xsl:text>
						<xsl:value-of select="@id"/>
						<!-- ref to UML:ActivityGraph -->
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:element name="UML:Diagram.element">
				<!-- elements -->
				<xsl:for-each select="key('edge.from',$selfNamespace)">
					<xsl:if test="child::type/@xlink:href='de.uni_paderborn.fujaba.asg.ASGDiagram::elements'">
						<xsl:element name="UML:DiagramElement">
							<xsl:attribute name="xmi.id">
								<!--find id-->
								<xsl:value-of select="$selfNamespace"/>
								<xsl:text>.</xsl:text>
								<xsl:value-of select="position()"/>
							</xsl:attribute>
							<xsl:element name="UML:PresentationElement.subject">
								<xsl:element name="Foundation.Core.ModelElement">
									<xsl:attribute name="xmi.idref">
										<xsl:value-of select="@to"/>
									</xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
		<!-- UML:ActivityGraph (done in package template)-->
		<!-- UML:TaggedValue -->
	</xsl:template>
</xsl:stylesheet>
<!--
  - $Log: gxl2xmi.xsl,v $
  - Revision 1.6  2004/10/20 17:50:38  schneider
  - Introduction of interfaces for class diagram classes
  -
  - Revision 1.1.1.1  2004/09/20 09:12:49  cschneid
  - initial version
  -
  - Revision 1.5  2003/04/15 06:29:48  hoven
  - latest version of gxl import/export
  -
  -->
